/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.IWSTypeEntry;
import filenet.ws.api.WSAttribute;
import filenet.ws.api.WSDefinedElement;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSElementDecl;
import filenet.ws.api.WSParam;
import filenet.ws.api.WSParamArray;
import filenet.ws.api.WSParamChoices;
import filenet.ws.api.WSParamGroup;
import filenet.ws.api.WSParamLeaf;
import filenet.ws.api.WSParamParent;
import filenet.ws.api.WSParameter;
import filenet.ws.api.WSPart;
import filenet.ws.api.WSType;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WSMember {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSMember";
    private static final int None_Member = 0;
    private static final int DefinedElement_Member = 1;
    private static final int ElementDecl_Member = 2;
    private static final int Parameter_Member = 3;
    private static final int Type_Member = 4;
    private static final int Part_Member = 5;
    private static final int Attribute_Member = 6;
    private static final int Choice_Member = 7;
    private static final int ElementDecl_Group_Member = 8;
    private static final int max_recursive_level = 1;
    private WSDefinition m_definition = null;
    private WSMember m_parentMember = null;
    private String m_parentNamespace = null;
    private WSDefinedElement m_element = null;
    private WSElementDecl m_elementDecl = null;
    private WSAttribute m_attribute = null;
    private WSParameter m_parameter = null;
    private WSElementDecl[] m_elementDeclGroup = null;
    private Vector m_choices = null;
    private IWSTypeEntry[] m_references = null;
    private WSType m_type = null;
    private IWSTypeEntry m_collectionTypeEntry = null;
    private WSType m_collectionElementType = null;
    private WSType m_baseType = null;
    private WSPart m_part = null;
    private String m_baseName = null;
    private WSMember[] m_members = null;
    private Vector m_memberVector = null;
    private String m_namespace = null;
    private boolean m_bAttachmentRef = false;
    private boolean m_bXmlString = false;
    private WSParam m_param = null;
    private String m_typeString = null;
    private int m_memberType = 0;
    private String m_name = null;
    private String m_partName = null;
    private boolean m_blankType = false;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:00:22  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.46  $";
    }

    public void releaseReferences() {
        block12: {
            try {
                int i;
                this.m_definition = null;
                this.m_parentMember = null;
                this.m_parentNamespace = null;
                this.m_element = null;
                this.m_typeString = null;
                this.m_name = null;
                this.m_partName = null;
                this.m_parentNamespace = null;
                this.m_namespace = null;
                this.m_baseName = null;
                this.m_attribute = null;
                this.m_parameter = null;
                this.m_type = null;
                this.m_collectionElementType = null;
                this.m_baseType = null;
                this.m_part = null;
                this.m_collectionTypeEntry = null;
                this.m_param = null;
                this.m_typeString = null;
                this.m_name = null;
                this.m_partName = null;
                if (this.m_elementDeclGroup != null) {
                    WSElementDecl[] elementDeclGroup = this.m_elementDeclGroup;
                    this.m_elementDeclGroup = null;
                    for (i = 0; i < elementDeclGroup.length; ++i) {
                        elementDeclGroup[i] = null;
                    }
                    elementDeclGroup = null;
                }
                if (this.m_choices != null) {
                    Vector choices = this.m_choices;
                    this.m_choices = null;
                    WSElementDecl[] elementDeclGroup = null;
                    Object obj = null;
                    for (int i2 = choices.size() - 1; i2 >= 0; --i2) {
                        obj = choices.remove(i2);
                        if (!(obj instanceof WSElementDecl[])) continue;
                        elementDeclGroup = obj;
                        for (int j = 0; j < elementDeclGroup.length; ++j) {
                            elementDeclGroup[j] = null;
                        }
                        elementDeclGroup = null;
                    }
                    obj = null;
                    choices = null;
                    elementDeclGroup = null;
                }
                if (this.m_references != null) {
                    IWSTypeEntry[] references = this.m_references;
                    this.m_references = null;
                    for (i = 0; i < references.length; ++i) {
                        references[i] = null;
                    }
                    references = null;
                }
                if (this.m_memberVector != null) {
                    this.m_memberVector.removeAllElements();
                    this.m_memberVector = null;
                }
                if (this.m_members != null) {
                    WSMember[] members = this.m_members;
                    this.m_members = null;
                    WSMember member = null;
                    for (int i3 = 0; i3 < members.length; ++i3) {
                        if (members[i3] == null) continue;
                        member = members[i3];
                        members[i3] = null;
                        member.releaseReferences();
                    }
                    members = null;
                    Object var2_5 = null;
                }
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block12;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSMember(WSDefinition definition, WSMember parentMember, Object obj) {
        this.m_definition = definition;
        this.m_memberVector = new Vector();
        if (obj instanceof WSDefinedElement) {
            this.init(parentMember, (WSDefinedElement)obj);
        } else if (obj instanceof WSElementDecl) {
            this.init(parentMember, (WSElementDecl)obj);
        } else if (obj instanceof WSParameter) {
            this.init(parentMember, (WSParameter)obj);
        } else if (obj instanceof WSAttribute) {
            this.init(parentMember, (WSAttribute)obj);
        } else if (obj instanceof WSType) {
            this.init(parentMember, (WSType)obj);
        } else if (obj instanceof WSPart) {
            this.init(parentMember, (WSPart)obj);
        } else if (obj instanceof Vector) {
            this.init(parentMember, (Vector)obj);
        } else if (obj instanceof WSElementDecl[]) {
            this.init(parentMember, (WSElementDecl[])obj);
        }
    }

    public WSMember(WSDefinition definition, String parentNamespace, Object obj) {
        this.m_definition = definition;
        this.m_memberVector = new Vector();
        if (obj instanceof WSDefinedElement) {
            this.init(parentNamespace, (WSDefinedElement)obj);
        } else if (obj instanceof WSPart) {
            this.init(parentNamespace, (WSPart)obj);
        } else if (obj instanceof WSParameter) {
            this.init(parentNamespace, (WSParameter)obj);
        }
    }

    private void init(String parentNamespace, WSDefinedElement element) {
        this.init((WSMember)null, element);
        this.m_parentNamespace = parentNamespace;
    }

    private void init(WSMember parentMember, WSDefinedElement element) {
        Object type = null;
        this.m_parentMember = parentMember;
        this.m_element = element;
        if (this.m_element != null) {
            this.m_typeString = "DefinedElement";
            this.m_memberType = 1;
            this.m_name = this.m_element.getDefinedElement().getQName().getLocalPart();
            this.getName();
            this.m_references = this.m_element.getReferences();
        }
    }

    private void init(WSMember parentMember, WSElementDecl elementDecl) {
        this.m_parentMember = parentMember;
        this.m_elementDecl = elementDecl;
        if (this.m_elementDecl != null) {
            this.m_typeString = "ElementDecl";
            this.m_memberType = 2;
            this.m_name = this.m_elementDecl.getElementDecl().getQName().getLocalPart();
            this.m_references = elementDecl.getReferences();
        }
    }

    private void init(WSMember parentMember, WSAttribute attribute) {
        this.m_parentMember = parentMember;
        this.m_attribute = attribute;
        if (this.m_attribute != null) {
            this.m_typeString = "Attribute";
            this.m_memberType = 6;
            this.m_name = this.m_attribute.getQName().getLocalPart();
            this.m_references = new IWSTypeEntry[1];
            this.m_references[0] = this.m_attribute.getType();
        }
    }

    private void init(WSMember parentMember, Vector choices) {
        this.m_parentMember = parentMember;
        this.m_choices = choices;
        if (this.m_choices != null) {
            this.m_typeString = "Choice_Member";
            this.m_memberType = 7;
        }
    }

    private void init(WSMember parentMember, WSElementDecl[] elementDeclGroup) {
        this.m_parentMember = parentMember;
        this.m_elementDeclGroup = elementDeclGroup;
        if (this.m_elementDeclGroup != null) {
            this.m_typeString = "ElementDeclGroup_Member";
            this.m_memberType = 8;
        }
    }

    private void init(String parentNamespace, WSParameter param) {
        this.init((WSMember)null, param);
        this.m_parentNamespace = parentNamespace;
    }

    private void init(WSMember parentMember, WSParameter param) {
        this.m_parentMember = parentMember;
        this.m_parameter = param;
        if (this.m_parameter != null) {
            this.m_typeString = "Parameter";
            this.m_memberType = 3;
            this.m_name = this.m_parameter.getName();
            this.m_references = new IWSTypeEntry[1];
            this.m_references[0] = this.m_parameter.getType();
        }
    }

    private void init(WSMember parentMember, WSType type) {
        this.m_parentMember = parentMember;
        this.m_typeString = "Type";
        this.m_memberType = 4;
        this.m_name = type.getType().getQName().getLocalPart();
        this.m_type = type;
        this.m_references = this.m_type.getReferences();
    }

    private void init(String parentNamespace, WSPart part) {
        this.init((WSMember)null, part);
        this.m_parentNamespace = parentNamespace;
    }

    private void init(WSMember parentMember, WSPart part) {
        this.m_parentMember = parentMember;
        this.m_typeString = "Part";
        this.m_memberType = 5;
        if (part != null) {
            this.m_partName = part.getPartName();
            this.m_element = part.getElement();
            this.m_references = this.m_element != null ? this.m_element.getReferences() : part.getReferences();
            this.m_part = part;
            this.m_name = part.getName();
        }
    }

    WSParam getParam() {
        return this.m_param;
    }

    void initGroupMember() {
        if (this.m_memberType == 8 && this.m_elementDeclGroup != null && this.m_elementDeclGroup.length > 0) {
            WSMember member = null;
            if (this.m_elementDeclGroup != null && this.m_elementDeclGroup.length > 0) {
                for (int i = 0; i < this.m_elementDeclGroup.length; ++i) {
                    if (this.m_elementDeclGroup[i] == null) continue;
                    member = this.getElementDeclMember(this.m_elementDeclGroup[i]);
                    this.m_memberVector.add(member);
                }
            }
            if (this.m_memberVector != null && this.m_memberVector.size() > 0) {
                this.m_members = new WSMember[this.m_memberVector.size()];
                this.m_memberVector.toArray(this.m_members);
                this.m_memberVector.removeAllElements();
            }
        }
    }

    void initChoiceMember() {
        if (this.m_memberType == 7 && this.m_choices != null && this.m_choices.size() > 0) {
            Object obj = null;
            WSElementDecl[] elementDeclGroup = null;
            WSMember member = null;
            for (int i = 0; i < this.m_choices.size(); ++i) {
                obj = this.m_choices.get(i);
                if (obj == null) continue;
                if (obj instanceof WSElementDecl) {
                    member = this.getElementDeclMember(obj);
                    this.m_memberVector.add(member);
                    continue;
                }
                if (!(obj instanceof WSElementDecl[])) continue;
                elementDeclGroup = obj;
                member = this.m_definition.getMember(this, elementDeclGroup);
                if (member == null) {
                    member = this.m_definition.newMember(this, (Object)elementDeclGroup);
                }
                this.m_memberVector.add(member);
            }
            if (this.m_memberVector != null && this.m_memberVector.size() > 0) {
                this.m_members = new WSMember[this.m_memberVector.size()];
                this.m_memberVector.toArray(this.m_members);
                this.m_memberVector.removeAllElements();
            }
        }
    }

    WSMember getElementDeclMember(WSElementDecl elementDecl) {
        WSMember member = elementDecl.getDefinition().getMember(this, elementDecl);
        int level = 0;
        if (member != null) {
            level = this.ancestorLevel(member);
        }
        if (level == 0) {
            if (member == null) {
                member = elementDecl.getDefinition().newMember(this, (Object)elementDecl);
            }
            if (member != null) {
                if (member.isBaseType() || member.isCollectionElement() || member.getMemberCount() > 0) {
                    member.setBlankType(false);
                } else if (member.getType() != null) {
                    if (member.getType().isChoiceType() || member.getType().isEnumType()) {
                        member.setBlankType(false);
                    } else {
                        member.setBlankType(true);
                    }
                }
            }
        }
        return member;
    }

    void init() {
        if (this.recursiveLevel() > 1) {
            return;
        }
        if (this.m_memberType == 8) {
            this.initGroupMember();
            return;
        }
        if (this.m_memberType == 7) {
            this.initChoiceMember();
            return;
        }
        if (this.getType() != null) {
            int i;
            WSMember member = null;
            Vector elementDeclsWithChoiceGroups = this.getType().getElementDeclsWithChoicegroup();
            WSAttribute[] attributes = this.getType().getAttributes();
            WSType simpleBaseType = this.getType().getSimpleBaseType();
            WSElementDecl[] elementDecls = this.getType().getElementDecls();
            if (simpleBaseType != null && !this.m_type.isEnumType()) {
                this.m_type = simpleBaseType;
                if (this.m_type.isBaseType()) {
                    this.m_baseType = this.m_type;
                }
            }
            if (this.m_references != null && this.m_references.length > 0) {
                for (int i2 = 0; i2 < this.m_references.length; ++i2) {
                    Object typeEntry = null;
                    if (this.m_references[i2] == null) continue;
                    if (this.m_references[i2].isCollectionParent(this.isRPC())) {
                        this.m_collectionTypeEntry = this.m_references[i2];
                        if (i2 + 1 < this.m_references.length && this.m_references[i2 + 1] != null && this.m_references[i2 + 1] instanceof WSType) {
                            this.m_collectionElementType = (WSType)this.m_references[i2 + 1];
                        }
                        ++i2;
                        continue;
                    }
                    if (this.m_references[i2] instanceof WSType && ((WSType)this.m_references[i2]).isCollectionParent(this.isRPC())) {
                        this.m_collectionTypeEntry = this.m_references[i2];
                        if (i2 + 1 < this.m_references.length && this.m_references[i2 + 1] != null && this.m_references[i2 + 1] instanceof WSType) {
                            this.m_collectionElementType = (WSType)this.m_references[i2 + 1];
                        }
                        ++i2;
                        continue;
                    }
                    if (!(this.m_references[i2] instanceof WSType) || !((WSType)this.m_references[i2]).isBaseType()) continue;
                    this.m_baseType = (WSType)this.m_references[i2];
                }
            }
            if (elementDeclsWithChoiceGroups != null && elementDeclsWithChoiceGroups.size() > 0) {
                Object obj = null;
                WSElementDecl elementDecl = null;
                Vector choiceGroup = null;
                for (i = 0; i < elementDeclsWithChoiceGroups.size(); ++i) {
                    obj = elementDeclsWithChoiceGroups.get(i);
                    if (obj == null) continue;
                    if (obj instanceof WSElementDecl) {
                        elementDecl = obj;
                        choiceGroup = null;
                        if (elementDecl.getDefinition() == null) continue;
                        member = elementDecl.getDefinition().getMember(this, elementDecl);
                        int level = 0;
                        if (member != null) {
                            level = this.ancestorLevel(member);
                        }
                        if (level > 0) continue;
                        if (member == null) {
                            member = elementDecl.getDefinition().newMember(this, (Object)elementDecl);
                        }
                        if (member == null) continue;
                        if (member.isBaseType() || member.isCollectionElement() || member.getMemberCount() > 0) {
                            this.m_memberVector.add(member);
                            continue;
                        }
                        if (member.getType() == null) continue;
                        if (member.getType().isChoiceType() || member.getType().isEnumType()) {
                            this.m_memberVector.add(member);
                            continue;
                        }
                        member.setBlankType(true);
                        this.m_memberVector.add(member);
                        continue;
                    }
                    if (!(obj instanceof Vector)) continue;
                    elementDecl = null;
                    choiceGroup = obj;
                    if (choiceGroup == null || choiceGroup.size() <= 0) continue;
                    member = this.m_definition.getMember(this, choiceGroup);
                    if (member == null) {
                        member = this.m_definition.newMember(this, (Object)choiceGroup);
                    }
                    this.m_memberVector.add(member);
                }
            } else if (this.m_collectionTypeEntry != null && (this.m_memberType == 4 || this.m_memberType == 3 || this.m_memberType == 5)) {
                member = this.m_definition.getMember(this, this.m_collectionTypeEntry);
                if (member == null) {
                    member = this.m_definition.newMember(this, (Object)this.m_collectionTypeEntry);
                }
                if (member != null && (member.isBaseType() || member.isCollectionElement() || member.getMemberCount() > 0)) {
                    this.m_memberVector.add(member);
                }
            } else if (this.m_memberType == 4 && this.m_references != null && this.m_references.length > 0 && this.m_references[0] != null) {
                member = this.m_definition.getMember(this, this.m_references[0]);
                if (member == null) {
                    member = this.m_definition.newMember(this, (Object)this.m_references[0]);
                }
                if (member != null && (member.isBaseType() || member.isCollectionElement() || member.getMemberCount() > 0)) {
                    this.m_memberVector.add(member);
                }
            } else if (this.m_memberType == 2 && this.m_collectionTypeEntry != null) {
                IWSTypeEntry typeEntry = this.m_collectionTypeEntry;
                WSType refType = null;
                while (typeEntry != null) {
                    if (typeEntry instanceof WSType) {
                        refType = (WSType)typeEntry;
                        break;
                    }
                    if (!(typeEntry instanceof WSDefinedElement)) continue;
                    typeEntry = ((WSDefinedElement)this.m_collectionTypeEntry).getRefTypeEntry();
                }
                if (refType != null) {
                    while (refType != null) {
                        if (refType.getRefType() != null) {
                            refType = refType.getRefType();
                            continue;
                        }
                        if (refType.getSimpleBaseType() == null) break;
                        refType = refType.getSimpleBaseType();
                    }
                    if ((member = this.m_definition.getMember(this, refType)) == null) {
                        member = this.m_definition.newMember(this, (Object)refType);
                    }
                    if (member != null && (member.isBaseType() || member.isCollectionElement() || member.getMemberCount() > 0)) {
                        if (member.getMemberCount() == 1) {
                            this.m_memberVector.add(member);
                        } else {
                            WSMember[] childMembers = member.getMembers();
                            if (childMembers != null) {
                                for (i = 0; i < childMembers.length; ++i) {
                                    if (childMembers[i] == null) continue;
                                    this.m_memberVector.add(childMembers[i]);
                                }
                            }
                        }
                    }
                }
            }
            if (attributes != null && attributes.length > 0) {
                for (int i3 = 0; i3 < attributes.length; ++i3) {
                    if (attributes[i3] == null || attributes[i3].getDefinition() == null) continue;
                    member = attributes[i3].getDefinition().getMember(this, attributes[i3]);
                    if (member == null) {
                        member = attributes[i3].getDefinition().newMember(this, (Object)attributes[i3]);
                    }
                    if (member == null) continue;
                    if (member.isBaseType() || member.isCollectionElement() || member.getMemberCount() > 0) {
                        this.m_memberVector.add(member);
                        continue;
                    }
                    if (member.getType() == null || !member.getType().isChoiceType() && !member.getType().isEnumType()) continue;
                    this.m_memberVector.add(member);
                }
            }
            if (this.m_memberVector != null && this.m_memberVector.size() > 0) {
                this.m_members = new WSMember[this.m_memberVector.size()];
                this.m_memberVector.toArray(this.m_members);
                this.m_memberVector.removeAllElements();
            }
            if (this.getType().getName() != null && this.getType().getName().startsWith("attachmentRef")) {
                this.m_bAttachmentRef = true;
            }
            if (this.getType().getName() != null && this.getType().getName().startsWith("xmlString")) {
                this.m_bXmlString = true;
            }
        }
        if (this.m_element != null) {
            if (this.m_element.getName() != null && this.m_element.getName().indexOf("attachmentRefElement") != -1) {
                this.m_bAttachmentRef = true;
            }
            if (this.m_element.getName() != null && this.m_element.getName().indexOf("xmlStringElement") != -1) {
                this.m_bXmlString = true;
            }
        }
        if (this.m_members != null && this.m_members.length > 0) {
            for (int i = 0; i < this.m_members.length; ++i) {
                if (this.m_members[i] == null) continue;
                return;
            }
        }
        this.m_members = null;
        if (this.m_elementDecl != null) {
            this.m_bXmlString |= this.m_elementDecl.isXMLString();
            this.m_bAttachmentRef |= this.m_elementDecl.isAttachmentReference();
        }
    }

    protected void setBlankType(boolean bBlankType) {
        this.m_blankType = bBlankType;
    }

    protected boolean isBlankType() {
        return this.m_blankType;
    }

    public String getName() {
        if (this.m_name != null && this.m_name.lastIndexOf(">") != -1) {
            int index = this.m_name.lastIndexOf(">");
            this.m_name = this.m_name.substring(index + 1);
        }
        return this.m_name;
    }

    String getPartName() {
        return this.m_partName;
    }

    public boolean isCollectionElement() {
        boolean bResult = false;
        if (this.m_type != null) {
            if (this.isRPC() && (this.m_memberType == 2 || this.m_memberType == 4)) {
                bResult |= this.isCollectionParent();
            } else {
                if (this.m_memberType == 2 && this.m_elementDecl != null) {
                    bResult |= this.m_elementDecl.isCollectionElement();
                }
                if (this.m_memberType == 1 && this.m_element != null) {
                    bResult |= this.m_element.isCollectionElement();
                }
                bResult |= this.m_type.isCollectionElement();
            }
        }
        return bResult;
    }

    public boolean isCollectionParent() {
        if (this.isRPC()) {
            return this.m_type.isRPCCollection();
        }
        return this.m_type.isCollectionParent(this.isRPC());
    }

    boolean isEnum() {
        return this.getType() != null && this.getType().isEnumType();
    }

    boolean isChoice() {
        return this.getType() != null && this.getType().isChoiceType();
    }

    boolean isPartMember() {
        return this.getMemberType() == 5;
    }

    public String getMinOccurs() {
        if (this.m_collectionTypeEntry != null) {
            return this.m_collectionTypeEntry.getMinOccurs();
        }
        return this.getType().getMinOccurs();
    }

    public String getMaxOccurs() {
        if (this.m_collectionTypeEntry != null) {
            return this.m_collectionTypeEntry.getMaxOccurs();
        }
        return this.getType().getMaxOccurs();
    }

    public WSType getType() {
        if (this.m_type == null && this.m_references != null && this.m_references.length > 0) {
            for (int i = 0; i < this.m_references.length; ++i) {
                IWSTypeEntry typeEntry = this.m_references[i];
                if (typeEntry == null || !(typeEntry instanceof WSType)) continue;
                this.m_type = (WSType)typeEntry;
                break;
            }
        }
        return this.m_type;
    }

    public WSType getRefType() {
        if (this.m_references == null && this.m_type != null) {
            this.m_references = this.m_type.getReferences();
        }
        if (this.m_references != null && this.m_references.length > 0) {
            for (int i = 0; i < this.m_references.length; ++i) {
                IWSTypeEntry typeEntry = this.m_references[i];
                if (typeEntry == null || !(typeEntry instanceof WSType)) continue;
                return (WSType)typeEntry;
            }
        }
        return null;
    }

    boolean isBaseType() {
        return this.m_baseType != null;
    }

    void addToTemplate(Document doc, Element elt) {
        this.addToTemplate(doc, elt, 0);
    }

    void addToTemplate(Document doc, Element elt, int bindingStyle) {
        String nameSpace = null;
        String eltName = null;
        Element e = null;
        if (this.m_element != null || this.m_elementDecl != null || this.m_parameter != null || this.getType() != null) {
            if (this.m_element != null) {
                eltName = this.m_element.getDisplayName();
                nameSpace = this.m_element.getDefinedElement().getQName().getNamespaceURI();
            } else if (this.m_elementDecl != null) {
                eltName = this.m_elementDecl.getDisplayName();
                nameSpace = this.m_elementDecl.getElementDecl().getQName().getNamespaceURI();
            } else if (this.m_parameter != null) {
                eltName = this.m_parameter.getDisplayName();
                nameSpace = this.m_parameter.getParameter().getQName().getNamespaceURI();
            } else if (this.getType() != null) {
                eltName = this.getName();
                if (eltName == null) {
                    eltName = this.getType().getTypeLocalName();
                }
                nameSpace = this.getType().getType().getQName().getNamespaceURI();
            }
            e = this.getType() != null && this.m_memberType == 2 && this.isCollectionElement() && this.getType().getRefType().isBaseType() && this.getSiblingCount() == 1 ? elt : (this.getType() != null && this.m_memberType == 2 && (nameSpace == null || nameSpace.length() == 0) ? elt : doc.createElementNS(nameSpace, eltName));
            if (this.getType() != null && this.isCollectionElement()) {
                elt.appendChild(doc.createComment(elt.getNodeName() + " is an array of " + this.getType().getMinOccurs() + " to " + this.getType().getMaxOccurs() + " element(s)"));
                elt.appendChild(doc.createComment("Start of an array element"));
            }
            if (elt != e && (elt == null || elt.getNamespaceURI() == null || nameSpace.compareTo(elt.getNamespaceURI()) != 0) && nameSpace != null && nameSpace.length() > 0) {
                e.setAttribute("xmlns", nameSpace);
            }
            if (this.m_members != null) {
                for (int i = 0; i < this.m_members.length; ++i) {
                    if (this.m_members[i] == null) continue;
                    this.m_members[i].addToTemplate(doc, e, bindingStyle);
                }
            } else if (this.getType() != null) {
                String prefix;
                WSType type = this.getType();
                if (this.isCollectionElement()) {
                    type = this.getType().getRefType();
                }
                String typeName = type.getTypeLocalName();
                String s = type.getEnumValuesString();
                if (bindingStyle == 2 && (prefix = type.getNamespacePrefix()) != null && typeName != null) {
                    e.setAttribute("type", prefix + ":" + typeName);
                }
                Text textNode = null;
                textNode = s != null ? doc.createTextNode(s) : doc.createTextNode(typeName);
                if (this.isCollectionElement()) {
                    Element arrayElement = doc.createElement(eltName);
                    arrayElement.appendChild(textNode);
                    e.appendChild(arrayElement);
                } else {
                    e.appendChild(textNode);
                }
            }
            if (elt != e) {
                if (elt != null) {
                    elt.appendChild(e);
                } else if (doc != null) {
                    doc.appendChild(e);
                }
            }
            if (this.getType() != null && this.isCollectionElement()) {
                elt.appendChild(doc.createComment("End of an array element"));
            }
        }
    }

    String getNameSpace() {
        this.m_namespace = null;
        if ((this.m_namespace == null || this.m_namespace.length() == 0) && this.m_element != null) {
            this.m_namespace = this.m_element.getNamespace();
        }
        if ((this.m_namespace == null || this.m_namespace.length() == 0) && this.m_elementDecl != null) {
            this.m_namespace = this.m_elementDecl.getNamespace();
        }
        if ((this.m_namespace == null || this.m_namespace.length() == 0) && this.m_attribute != null) {
            this.m_namespace = this.m_attribute.getNamespace();
        }
        if ((this.m_namespace == null || this.m_namespace.length() == 0) && this.m_parameter != null) {
            this.m_namespace = this.m_parameter.getNamespace();
        }
        if (this.m_namespace != null) {
            return this.m_namespace;
        }
        return this.getParentNamespace();
    }

    String getParentNamespace() {
        if (this.m_parentNamespace == null && this.m_parentMember != null) {
            this.m_parentNamespace = this.m_parentMember.getNameSpace();
        }
        return this.m_parentNamespace;
    }

    void addNameSpace(Vector v) {
        this.getNameSpace();
        if (!v.contains(this.m_namespace)) {
            v.add(this.m_namespace);
        }
        if (this.m_members != null && this.m_members.length > 0) {
            for (int i = 0; i < this.m_members.length; ++i) {
                if (this.m_members[i] == null || this.ancestorLevel(this.m_members[i]) >= 3) continue;
                this.m_members[i].addNameSpace(v);
            }
        }
    }

    int getMemberType() {
        return this.m_memberType;
    }

    WSMember[] getMembers() {
        return this.m_members;
    }

    int getMemberCount() {
        if (this.m_members != null) {
            return this.m_members.length;
        }
        return 0;
    }

    WSMember getParentMember() {
        return this.m_parentMember;
    }

    int getSiblingCount() {
        if (this.m_parentMember != null) {
            return this.m_parentMember.getMemberCount();
        }
        return 0;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("\n***************** WSMember****************\n");
        s.append("Member type: " + this.m_typeString + "\n");
        s.append("name: " + this.getName() + "\n");
        s.append("namespace: " + this.m_namespace + "\n");
        s.append("collection: " + this.isCollectionElement() + "\n");
        if (this.getType() != null) {
            s.append("type name (display name): " + this.getType().getDisplayName() + "\n");
            s.append("type name (base name): " + this.getType().getBaseName() + "\n");
            s.append("type name (local name): " + this.getType().getTypeLocalName() + "\n");
        }
        if (this.getRefType() != null && this.getRefType() != this.getType()) {
            s.append("reference type name (display name): " + this.getRefType().getDisplayName() + "\n");
            s.append("reference type name (base name): " + this.getRefType().getBaseName() + "\n");
            s.append("reference type name (local name): " + this.getRefType().getTypeLocalName() + "\n");
        }
        s.append("base type: " + this.isBaseType() + "\n");
        s.append("base name: " + this.m_baseName + "\n");
        s.append("$$$$$$$$$$$$$$$$$$$$$ Members: $$$$$$$$$$$$$$$$$$$$$$$$$\n");
        if (this.m_members != null && this.m_members.length > 0) {
            s.append("Member count: " + this.m_members.length + "\n");
            for (int i = 0; i < this.m_members.length; ++i) {
                s.append("member[" + i + "]" + "\n");
                s.append(this.m_members[i].toString());
            }
        } else {
            s.append("Member count: 0\n");
        }
        s.append("***************** End of  " + this.getName() + "\n\n");
        return s.toString();
    }

    Vector addChoiceToParamList(WSParamParent parent) {
        Vector<WSParam> params = new Vector<WSParam>();
        if (this.m_members != null && this.m_members.length > 0) {
            for (int i = 0; i < this.m_members.length; ++i) {
                if (this.m_members[i] == null) continue;
                params.add(this.m_members[i].addToParamList(parent));
            }
        }
        return params;
    }

    Vector addElementDeclGroupTOParamList(WSParamParent parent) {
        Vector<WSParam> params = new Vector<WSParam>();
        if (this.m_members != null && this.m_members.length > 0) {
            for (int i = 0; i < this.m_members.length; ++i) {
                if (this.m_members[i] == null) continue;
                params.add(this.m_members[i].addToParamList(parent));
            }
        }
        return params;
    }

    WSParam addToParamList(WSParamParent parent) {
        if (this.m_memberType == 7) {
            WSParamChoices param = new WSParamChoices(parent);
            param.setAttachmentRef(this.m_bAttachmentRef);
            param.setXmlString(this.m_bXmlString);
            param.setRPC(this.isRPC());
            for (int i = 0; i < this.m_members.length; ++i) {
                param.addChoice(this.m_members[i].addToParamList(param));
            }
            return param;
        }
        if (this.m_memberType == 8) {
            WSParamGroup param = new WSParamGroup(parent);
            param.setAttachmentRef(this.m_bAttachmentRef);
            param.setXmlString(this.m_bXmlString);
            param.setRPC(this.isRPC());
            for (int i = 0; i < this.m_members.length; ++i) {
                param.addChild(this.m_members[i].addToParamList(param));
            }
            return param;
        }
        if (!this.isCollectionElement()) {
            if (this.m_members == null || this.m_members.length == 0) {
                WSParam param = null;
                if (this.isPartMember() && this.isBlankType()) {
                    param = new WSParamParent(parent, this.getName(), this.getNameSpace(), this.getType().getNamespacePrefix(), this.getType().getTypeLocalName());
                } else {
                    WSParamLeaf paramLeaf = new WSParamLeaf(parent, this.getName(), this.getNameSpace(), this.getType().getNamespacePrefix(), this.getType().getTypeLocalName());
                    param = paramLeaf;
                    paramLeaf.setBlankType(this.getType().isBlankType());
                    if (this.getType() != null && this.getType().isEnumType()) {
                        Vector v = this.getType().getEnumValues();
                        String[] enumValues = null;
                        if (v != null && v.size() > 1) {
                            enumValues = new String[v.size() - 1];
                            for (int i = 1; i < v.size(); ++i) {
                                enumValues[i - 1] = (String)v.get(i);
                            }
                            paramLeaf.setEnumValues(enumValues);
                        }
                    }
                    if (this.m_attribute != null) {
                        paramLeaf.setIsAttribute(true);
                    }
                }
                param.setAttachmentRef(this.m_bAttachmentRef);
                param.setXmlString(this.m_bXmlString);
                param.setRPC(this.isRPC());
                return param;
            }
            if (this.getType() != null && this.getType().isChoiceType()) {
                WSParamChoices param = new WSParamChoices(parent, this.getName(), this.getNameSpace(), this.getType().getNamespacePrefix(), this.getType().getTypeLocalName());
                param.setAttachmentRef(this.m_bAttachmentRef);
                param.setXmlString(this.m_bXmlString);
                param.setRPC(this.isRPC());
                for (int i = 0; i < this.m_members.length; ++i) {
                    param.addChoice(this.m_members[i].addToParamList(param));
                }
                return param;
            }
            WSType type = this.getType();
            if (type.getRestrictionBaseQName() == null && (this.isRPC() || !type.isCollectionParent(this.isRPC()))) {
                while (type != null && type.getRefType() != null) {
                    type = type.getRefType();
                }
            }
            String typeName = null;
            String typePrefix = null;
            if (type.getRestrictionBaseQName() != null) {
                typeName = type.getRestrictionBaseQName().getLocalPart();
                typePrefix = type.getRestrictionBasePrefix();
            } else {
                typeName = type.getQName().getLocalPart();
                typePrefix = this.m_definition.getNamespacePrefix(type.getQName().getNamespaceURI());
            }
            if (typeName != null && typeName.lastIndexOf(">") != -1) {
                typeName = typeName.substring(typeName.lastIndexOf(">") + 1);
            }
            WSParamParent param = new WSParamParent(parent, this.getName(), this.getNameSpace(), typePrefix, typeName);
            param.setAttachmentRef(this.m_bAttachmentRef);
            param.setXmlString(this.m_bXmlString);
            param.setRPC(this.isRPC());
            param.setBaseType(type.isBaseType());
            for (int i = 0; i < this.m_members.length; ++i) {
                param.addChild(this.m_members[i].addToParamList(param));
            }
            return param;
        }
        WSParamArray array = null;
        WSParam sampleArrayElement = null;
        WSType refType = this.getRefType();
        if (this.m_members == null || this.m_members.length == 0) {
            String typeName = null;
            if (refType != null) {
                String string = typeName = refType.getSimpleBaseType() == null ? refType.getTypeLocalName() : refType.getSimpleBaseType().getTypeLocalName();
                if (this.getMemberType() == 2 && refType.getRefType() != null) {
                    String eltName = null;
                    eltName = this.isRPC() ? refType.getRefType().getTypeLocalName() : this.getName();
                    sampleArrayElement = new WSParamLeaf(parent, eltName, this.getNameSpace(), refType.getRefType().getNamespacePrefix(), refType.getRefType().getTypeLocalName());
                    ((WSParamLeaf)sampleArrayElement).setBlankType(this.getType().isBlankType());
                } else if (this.getParentMember() != null && this.getParentMember().getMemberType() == 2) {
                    sampleArrayElement = new WSParamLeaf(parent, this.getName(), this.getNameSpace(), this.m_definition.getNamespacePrefix(this.getNameSpace()), typeName);
                } else {
                    sampleArrayElement = new WSParamLeaf(parent, refType.getTypeLocalName(), refType.getNamespace(), refType.getNamespacePrefix(), typeName);
                    ((WSParamLeaf)sampleArrayElement).setBlankType(this.getType().isBlankType());
                }
                sampleArrayElement.setAttachmentRef(this.m_bAttachmentRef);
                sampleArrayElement.setXmlString(this.m_bXmlString);
                sampleArrayElement.setRPC(this.isRPC());
            }
        } else if (refType != null) {
            if (refType.isChoiceType()) {
                WSParamChoices param = new WSParamChoices(parent, this.getName(), this.getNameSpace(), refType.getNamespacePrefix(), refType.getTypeLocalName());
                param.setAttachmentRef(this.m_bAttachmentRef);
                param.setXmlString(this.m_bXmlString);
                param.setRPC(this.isRPC());
                for (int i = 0; i < this.m_members.length; ++i) {
                    param.addChoice(this.m_members[i].addToParamList(param));
                }
                sampleArrayElement = param;
            } else {
                WSMember[] members = this.m_members;
                String baseTypeName = null;
                String typeName = null;
                if (this.isBaseType()) {
                    baseTypeName = this.m_baseType.getTypeLocalName();
                }
                if (this.getMemberType() == 2 && refType.getRefType() != null) {
                    String eltName = null;
                    eltName = this.isRPC() ? refType.getRefType().getTypeLocalName() : this.getName();
                    typeName = this.isBaseType() ? baseTypeName : refType.getRefType().getTypeLocalName();
                    sampleArrayElement = new WSParamParent(parent, eltName, this.getNameSpace(), refType.getRefType().getNamespacePrefix(), typeName);
                } else if (this.getParentMember() != null && this.getParentMember().getMemberType() == 2) {
                    typeName = this.isBaseType() ? baseTypeName : refType.getTypeLocalName();
                    sampleArrayElement = new WSParamParent(parent, this.getName(), this.getNameSpace(), this.m_definition.getNamespacePrefix(this.getNameSpace()), typeName);
                } else if (this.m_members != null && this.m_members.length == 1 && this.m_members[0] != null) {
                    refType = this.m_members[0].getType();
                    typeName = this.isBaseType() ? baseTypeName : refType.getTypeLocalName();
                    sampleArrayElement = new WSParamParent(parent, refType.getTypeLocalName(), refType.getNamespace(), refType.getNamespacePrefix(), typeName);
                    members = this.m_members[0].getMembers();
                } else {
                    typeName = this.isBaseType() ? baseTypeName : refType.getTypeLocalName();
                    sampleArrayElement = new WSParamParent(parent, refType.getTypeLocalName(), refType.getNamespace(), refType.getNamespacePrefix(), typeName);
                }
                sampleArrayElement.setAttachmentRef(this.m_bAttachmentRef);
                sampleArrayElement.setXmlString(this.m_bXmlString);
                sampleArrayElement.setRPC(this.isRPC());
                sampleArrayElement.setBaseType(this.isBaseType());
                if (members != null) {
                    for (int i = 0; i < members.length; ++i) {
                        ((WSParamParent)sampleArrayElement).addChild(members[i].addToParamList((WSParamParent)sampleArrayElement));
                    }
                }
            }
        }
        array = new WSParamArray(parent, this.getName(), this.getNameSpace(), refType.getNamespacePrefix(), refType.getTypeLocalName(), sampleArrayElement, this.getMinOccurs(), this.getMaxOccurs());
        array.setAttachmentRef(this.m_bAttachmentRef);
        array.setXmlString(this.m_bXmlString);
        array.setRPC(this.isRPC());
        return array;
    }

    private boolean isAncestor(WSMember member) {
        if (member == this) {
            return true;
        }
        if (this.m_parentMember != null) {
            return this.m_parentMember.isAncestor(member);
        }
        return false;
    }

    private int ancestorLevel(WSMember member) {
        int level = this.ancestorLevel(0, member);
        return level;
    }

    private int ancestorLevel(int level, WSMember member) {
        if (member == null) {
            return level;
        }
        if (member == this && this.m_parentMember == member.getParentMember()) {
            ++level;
        }
        if (this.m_parentMember != null) {
            return this.m_parentMember.ancestorLevel(level, member);
        }
        return level;
    }

    private int recursiveLevel(WSType type) {
        int level = 0;
        if (type != null) {
            for (WSMember parentMember = this; parentMember != null; parentMember = parentMember.getParentMember()) {
                if (type != parentMember.getType()) continue;
                ++level;
            }
        }
        return level;
    }

    private int recursiveLevel() {
        WSType type = this.getType();
        WSMember parentMember = this.getParentMember();
        if (parentMember != null && type != null) {
            return parentMember.recursiveLevel(type);
        }
        return 0;
    }

    boolean isRPC() {
        if (this.m_part != null) {
            return this.m_part.isRPC();
        }
        if (this.m_parameter != null) {
            return this.m_parameter.isPRC();
        }
        if (this.m_parentMember != null) {
            return this.m_parentMember.isRPC();
        }
        return false;
    }
}

